/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.base;

import com.nyfaria.numismaticoverhaul.owostuff.ui.base.BaseOwoScreen;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.OwoUIAdapter;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModel;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModelLoader;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.UIErrorToast;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseUIModelScreen<R extends ParentComponent>
extends BaseOwoScreen<R> {
    protected final UIModel model;
    protected final Class<R> rootComponentClass;

    protected BaseUIModelScreen(Class<R> rootComponentClass, DataSource source) {
        UIModel providedModel = source.get();
        if (providedModel == null) {
            source.reportError();
            this.invalid = true;
        }
        this.rootComponentClass = rootComponentClass;
        this.model = providedModel;
    }

    @Override
    @NotNull
    protected OwoUIAdapter<R> createAdapter() {
        return this.model.createAdapter(this.rootComponentClass, this);
    }

    public static interface DataSource {
        @Nullable
        public UIModel get();

        public void reportError();

        public static DataSource file(final String filePath) {
            return new DataSource(){

                @Override
                @Nullable
                public UIModel get() {
                    throw new IllegalStateException("Debug UI data source must not be used in production");
                }

                @Override
                public void reportError() {
                    UIErrorToast.report("Could not load UI model from file " + filePath);
                }
            };
        }

        public static DataSource asset(final ResourceLocation assetPath) {
            return new DataSource(){

                @Override
                @Nullable
                public UIModel get() {
                    return UIModelLoader.getPreloaded(assetPath);
                }

                @Override
                public void reportError() {
                    UIErrorToast.report("No UI model with id " + assetPath + " was found");
                }
            };
        }
    }
}

